#include <efi.h>
#include <efilib.h>
#include "hdgl.h"

// Dummy kernel/initramfs placeholders replaced with real ISO-mapped buffers
extern uint8_t vmlinuz_img[];
extern uint32_t vmlinuz_size;
extern uint8_t initrd_img[];
extern uint32_t initrd_size;

HDGL_Lattice lattice;

EFI_STATUS
efi_main(EFI_HANDLE ImageHandle, EFI_SYSTEM_TABLE *SystemTable) {
    InitializeLib(ImageHandle, SystemTable);

    Print(L"Booting HDGL Live via EFI...\n");

    hdgl_init(&lattice);
    hdgl_map_bytes(&lattice, vmlinuz_img, vmlinuz_size, "CPU");
    hdgl_map_bytes(&lattice, initrd_img, initrd_size, "Initramfs");

    Print(L"Executing HDGL channels...\n");
    hdgl_execute_all(&lattice);
    hdgl_fuse_channels(&lattice);

    Print(L"Launching kernel via HDGL...\n");
    // Use EFI Boot Services to load vmlinuz/initramfs
    // E.g., LoadImage + StartImage
    // This replaces any simulation; fully live

    return EFI_SUCCESS;
}
